﻿//////////////////////////////////////////////
// GltfEncoderUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkExport
{
	class Node ;
}

namespace nkGraphics
{
	class LogManager ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../../Meshes/Enums/PrimitiveTopology.h"

#include "../../../Utils/DxDefinesWrapper.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class GltfEncoderUtils final
	{
		public :

			// Checks
			static bool validateJsonStructure (nkExport::Node* tree) ;
			static bool validateAccessor (nkExport::Node* node) ;
			static bool validateBufferView (nkExport::Node* node) ;
			static bool validateBuffer (nkExport::Node* node) ;
			static bool validateAccessorPathToBuffer (nkExport::Node* tree, unsigned int accessorIndex, LogManager* logManager) ;

			// Conversions
			static unsigned int getComponentTypeByteSize (unsigned int componentType) ;
			static PRIMITIVE_TOPOLOGY getTopologyFromMode (unsigned int mode) ;
			static FORMAT getFormatFromAccessorData (nkMemory::StringView type, unsigned int componentType, bool normalized) ;
			static unsigned int getComponentCountFromAccessorData (nkMemory::StringView type) ;
			static unsigned int getArraySizeFromAccessorData (nkMemory::StringView type) ;
	} ;
}